<?php
// Устанавливаем режим отладки
define('DEBUG', true); // false для production окружения

// Базовые настройки приложения
define('PROJECT_NAME', 'Cyberspace');
define('BASE_DIR', __DIR__ . '/../data/'); // Корневая директория данных
define('PUBLIC_DIR', BASE_DIR . 'public/'); // Публичная директория
define('USER_DATA_DIR', BASE_DIR . '{username}/'); // Директория пользователя

// Настройки для работы с файлами и папками
$filePermissions = [
    'read' => 0644,
    'write' => 0666,
];

// Подключение библиотек
require_once __DIR__ . '/../lib/Parsedown.php'; // Пример подключения библиотеки Parsedown для Markdown
$parsedown = new Parsedown();

// Настройка обработки ошибок
if (DEBUG) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
    // Логирование ошибок в файл
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/error.log');
}
?>