console.log('JavaScript загружен');
document.addEventListener('DOMContentLoaded', () => {
    const folderList = document.getElementById('folder-list');
    const fileContent = document.getElementById('file-content');

    // Пример данных для папок и файлов с правильными путями
    const folders = [
        { name: 'public', path: PUBLIC_DIR, children: [] },
        { 
            name: 'documents', 
            path: USER_DATA_DIR . 'user1/', 
            children: [
                { name: 'report.txt', path: USER_DATA_DIR . 'user1/report.txt' },
                { name: 'notes.md', path: USER_DATA_DIR . 'user1/notes.md' }
            ]
        }
    ];

    // Функция для рекурсивного создания списка папок
    function renderFolderList(folders, parentElement) {
        folders.forEach(folder => {
            const li = document.createElement('li');
            li.textContent = folder.name;
            if (folder.children && folder.children.length > 0) {
                li.classList.add('has-child');
                const ul = document.createElement('ul');
                renderFolderList(folder.children, ul);
                li.appendChild(ul);
            }
            parentElement.appendChild(li);
        });
    }

    // Рендер списка папок
    renderFolderList(folders, folderList);

    // Обработка кликов по элементам списка папок
    folderList.addEventListener('click', (event) => {
        const target = event.target;
        if (target.classList.contains('has-child')) {
            target.querySelector('ul').style.display = 
                target.querySelector('ul').style.display === 'block' ? 'none' : 'block';
        } else if (!target.closest('.sidebar')) {
            // Очистка предыдущего содержимого файлов
            fileContent.innerHTML = '';

            // Пример загрузки и отображения содержимого файла
            const filePath = target.textContent;
            fetch(filePath)
                .then(response => response.text())
                .then(text => {
                    if (filePath.endsWith('.md')) {
                        fileContent.innerHTML = $parsedown.parse(text);
                    } else {
                        fileContent.textContent = text;
                    }
                })
                .catch(error => console.error('Ошибка при загрузке файла:', error));
        }
    });
});